package ru.yandex.direct.internaltools.tools.canvas.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class OnCreativeIdsOperationParameter extends InternalToolParameter {
    @Input(label = "Операция")
    OperationName operationName;

    @Input(label = "Список Id креативов")
    @TextArea
    String creativeIds;

    public OperationName getOperationName() {
        return operationName;
    }

    public void setOperationName(OperationName operationName) {
        this.operationName = operationName;
    }

    public String getCreativeIds() {
        return creativeIds;
    }

    public void setCreativeIds(String creativeIds) {
        this.creativeIds = creativeIds;
    }

    public enum OperationName {
        RESHOOT_SCREENSHOT("reshoot_screenshot"),
        REBUILD("rebuild"),
        SEND_TO_DIRECT("send_to_direct"),
        SEND_TO_RTBHOST("send_to_rtbhost");

        private String operationName;

        OperationName(String name) {
            this.operationName = name;
        }

        public String getOperationName() {
            return operationName;
        }
    }
}
