package ru.yandex.direct.internaltools.tools.canvas.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.canvas.model.OnCreativeOperationResult;
import ru.yandex.direct.canvas.model.OnCreativeOperationResultStatus;

public class OnCreativeOperationResultWithId {
    @JsonProperty("creative_id")
    private Long creativeId;

    @JsonProperty("status")
    private OnCreativeOperationResultStatus status;

    @JsonProperty("errors")
    private List<String> errors;

    public OnCreativeOperationResultWithId(Long creativeId, OnCreativeOperationResult result) {
        this.creativeId = creativeId;
        this.status = result.getStatus();
        this.errors = result.getErrors();
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public OnCreativeOperationResultStatus getStatus() {
        return status;
    }

    public List<String> getErrors() {
        return errors;
    }
}
