package ru.yandex.direct.internaltools.tools.canvas.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class VideoConstructorOperationParameter extends InternalToolParameter {
    @Input(label = "Операция")
    OperationName operationName;

    @Input(label = "Список Id файлов Видеоконструктора через запятую")
    @TextArea
    String fileIds;

    public OperationName getOperationName() {
        return operationName;
    }

    public void setOperationName(OperationName operationName) {
        this.operationName = operationName;
    }

    public String getFileIds() {
        return fileIds;
    }

    public void setFileIds(String fileIds) {
        this.fileIds = fileIds;
    }

    public enum OperationName {
        REBUILD_PACKSHOT("Перегенерировать пакшот"),
        REBUILD_PREVIEW("Перегенерировать превью");

        private String operationName;

        OperationName(String name) {
            this.operationName = name;
        }

        public String getOperationName() {
            return operationName;
        }
    }
}
