package ru.yandex.direct.internaltools.tools.cashback.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.cashback.preprocessors.CashbackCategorySelectPreprocessor;

import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.CATEGORY_BUTTON_LINK_MAX_LENGTH;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.CATEGORY_BUTTON_TEXT_MAX_LENGTH;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.CATEGORY_DESCRIPTION_MAX_LENGTH;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.CATEGORY_FIELD_UPDATE_PROMPT;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.CATEGORY_NAME_MAX_LENGTH;

/**
 * Параметры для создания или редактирования категории.
 * <p>
 * Все поля необязательны, но валидация должна проверять наличие и правильность всех полей
 * кроме {@code selectedCategoryName} в случае создания новой категории
 */
public class CashbackCategoriesParams extends InternalToolParameter {

    @Input(label = "Категория", processors = CashbackCategorySelectPreprocessor.class, required = false)
    @Select(preprocessed = true)
    private String categoryKey;

    @Input(label = "Название категории на русском",
            description = "Максимум " + CATEGORY_NAME_MAX_LENGTH + " символов. " + CATEGORY_FIELD_UPDATE_PROMPT,
            required = false)
    @Text
    private String nameRu;

    @Input(label = "Название категории на английском",
            description = "Максимум " + CATEGORY_NAME_MAX_LENGTH + " символов. " + CATEGORY_FIELD_UPDATE_PROMPT,
            required = false)
    @Text
    private String nameEn;

    @Input(label = "Описание категории на русском",
            description = "Максимум " + CATEGORY_DESCRIPTION_MAX_LENGTH + " символов. " + CATEGORY_FIELD_UPDATE_PROMPT,
            required = false)
    @TextArea
    private String descriptionRu;

    @Input(label = "Описание категории на английском",
            description = "Максимум " + CATEGORY_DESCRIPTION_MAX_LENGTH + " символов. " + CATEGORY_FIELD_UPDATE_PROMPT,
            required = false)
    @TextArea
    private String descriptionEn;

    @Input(label = "Текст кнопки на карточке категории на русским",
            description = "Максимум " + CATEGORY_BUTTON_TEXT_MAX_LENGTH + " символов. " + CATEGORY_FIELD_UPDATE_PROMPT,
            required = false)
    @TextArea
    private String buttonTextRu;

    @Input(label = "Текст кнопки на карточке категории на английском",
            description = "Максимум " + CATEGORY_BUTTON_TEXT_MAX_LENGTH + " символов. " + CATEGORY_FIELD_UPDATE_PROMPT,
            required = false)
    @TextArea
    private String buttonTextEn;

    @Input(label = "Ссылка для перехода при нажатии на кнопку на карточке категории",
            description = "Максимум " + CATEGORY_BUTTON_LINK_MAX_LENGTH + " символов. " + CATEGORY_FIELD_UPDATE_PROMPT,
            required = false)
    @TextArea
    private String buttonLink;

    public String getCategoryKey() {
        return categoryKey;
    }

    public CashbackCategoriesParams withCategoryKey(String categoryKey) {
        this.categoryKey = categoryKey;
        return this;
    }

    public String getNameRu() {
        return nameRu;
    }

    public CashbackCategoriesParams withNameRu(String nameRu) {
        this.nameRu = nameRu;
        return this;
    }

    public String getNameEn() {
        return nameEn;
    }

    public CashbackCategoriesParams withNameEn(String nameEn) {
        this.nameEn = nameEn;
        return this;
    }

    public String getDescriptionRu() {
        return descriptionRu;
    }

    public CashbackCategoriesParams withDescriptionRu(String descriptionRu) {
        this.descriptionRu = descriptionRu;
        return this;
    }

    public String getDescriptionEn() {
        return descriptionEn;
    }

    public CashbackCategoriesParams withDescriptionEn(String descriptionEn) {
        this.descriptionEn = descriptionEn;
        return this;
    }

    public String getButtonTextRu() {
        return buttonTextRu;
    }

    public CashbackCategoriesParams withButtonTextRu(String buttonTextRu) {
        this.buttonTextRu = buttonTextRu;
        return this;
    }

    public String getButtonTextEn() {
        return buttonTextEn;
    }

    public CashbackCategoriesParams withButtonTextEn(String buttonTextEn) {
        this.buttonTextEn = buttonTextEn;
        return this;
    }

    public String getButtonLink() {
        return buttonLink;
    }

    public CashbackCategoriesParams withButtonLink(String buttonLink) {
        this.buttonLink = buttonLink;
        return this;
    }
}
