package ru.yandex.direct.internaltools.tools.cashback.model;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.cashback.preprocessors.CashbackCategorySelectPreprocessor;
import ru.yandex.direct.internaltools.tools.cashback.preprocessors.CashbackProgramSelectPreprocessor;

public class CashbackProgramCategoryParams extends InternalToolParameter {
    public enum Action {
        SHOW("Показать"),
        CREATE("Создать"),
        UPDATE("Изменить"),
        DELETE("Удалить");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Select
    @Input(label = "Действие")
    private Action action;

    @Input(label = "Категория", description = "Категория, к которой нужно привязать программу",
            processors = CashbackCategorySelectPreprocessor.class, required = false)
    @Select(preprocessed = true)
    private String categoryKey;

    @Input(label = "Программа", description = "Программа для привязки к категории",
            processors = CashbackProgramSelectPreprocessor.class, required = false)
    @Select(preprocessed = true)
    private String programKey;

    @Input(label = "Порядок программы", description = "Целое неотрицательное число", required = false)
    @Text
    private String order;

    public Action getAction() {
        return action;
    }

    public CashbackProgramCategoryParams withAction(Action action) {
        this.action = action;
        return this;
    }

    public String getCategoryKey() {
        return categoryKey;
    }

    public CashbackProgramCategoryParams withCategoryKey(String categoryKey) {
        this.categoryKey = categoryKey;
        return this;
    }

    public String getProgramKey() {
        return programKey;
    }

    public CashbackProgramCategoryParams withProgramKey(String programKey) {
        this.programKey = programKey;
        return this;
    }

    public String getOrder() {
        return order;
    }

    public CashbackProgramCategoryParams withOrder(String order) {
        this.order = order;
        return this;
    }
}
