package ru.yandex.direct.internaltools.tools.cashback.model;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.cashback.preprocessors.CashbackCategorySelectPreprocessor;
import ru.yandex.direct.internaltools.tools.cashback.preprocessors.CashbackProgramSelectPreprocessor;

import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.PROGRAM_NAME_MAX_LENGTH;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.PROGRAM_TOOLTIP_INFO_MAX_LENGTH;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.PROGRAM_TOOLTIP_LINK_MAX_LENGTH;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.PROGRAM_TOOLTIP_LINK_TEXT_MAX_LENGTH;

public class CashbackProgramsParams extends InternalToolParameter {

    public enum Action {
        SHOW("Показать"),
        CREATE("Создать"),
        UPDATE("Изменить");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Select
    @Input(label = "Действие")
    private Action action;

    @Input(label = "Категория", description = "Устаревшее поле, для установления связей между программами и " +
            "категориями используйте инструмент \"Управление связью программ и категорий кешбеков\"",
            processors = CashbackCategorySelectPreprocessor.class, required = false)
    @Select(preprocessed = true)
    private String categoryKey;

    @Input(label="Программа", description = "Выберите для изменения программы",
            processors = CashbackProgramSelectPreprocessor.class, required = false)
    @Select(preprocessed = true)
    private String programKey;

    @Input(label="Процент программы", description = "Заполните при создании программы", required = false)
    @Text
    private String percent;

    @Input(label = "Название программы (ru)", description = "Название программы на русском, максимум " +
            PROGRAM_NAME_MAX_LENGTH + " символов", required = false)
    @Text
    private String nameRu;

    @Input(label = "Название программы (en)", description = "Название программы на английском, максимум " +
            PROGRAM_NAME_MAX_LENGTH + " символов", required = false)
    @Text
    private String nameEn;

    @Input(label = "Текст в всплывающем окне (ru)",
            description = "Текст в всплывающем окне программы на русском, максимум " +
                    PROGRAM_TOOLTIP_INFO_MAX_LENGTH + " символов", required = false)
    @Text
    private String tooltipInfoRu;

    @Input(label = "Текст в всплывающем окне (en)",
            description = "Текст в всплывающем окне программы на английском, максимум " +
                    PROGRAM_TOOLTIP_INFO_MAX_LENGTH + " символов", required = false)
    @Text
    private String tooltipInfoEn;

    @Input(label = "Текст ссылки в всплывающем окне (ru)",
            description = "Текст ссылки в всплывающем окне на русском, максимум " +
                    PROGRAM_TOOLTIP_LINK_TEXT_MAX_LENGTH + " символов", required = false)
    @Text
    private String tooltipLinkTextRu;

    @Input(label = "Текст ссылки в всплывающем окне (en)",
            description = "Текст ссылки в всплывающем окне на английском, максимум " +
                    PROGRAM_TOOLTIP_LINK_TEXT_MAX_LENGTH + " символов", required = false)
    @Text
    private String tooltipLinkTextEn;

    @Input(label = "Ссылка в всплывающем окне", description = "Ссылка в всплывающем окне, максимум " +
            PROGRAM_TOOLTIP_LINK_MAX_LENGTH + " символов", required = false)
    @Text
    private String tooltipLink;

    @Input(label="Включена", required = false)
    @CheckBox(checked = false)
    private Boolean isEnabled;

    @Input(label="Публичная", required = false)
    @CheckBox(checked = false)
    private Boolean isPublic;

    @Input(label = "Техническая", required = false)
    @CheckBox(checked = false)
    private Boolean isTechnical;

    @Input(label = "Новая", required = false)
    @CheckBox(checked = false)
    private Boolean isNew;

    public Action getAction() {
        return action;
    }

    public CashbackProgramsParams withAction(Action action) {
        this.action = action;
        return this;
    }

    public String getCategoryKey() {
        return categoryKey;
    }

    public CashbackProgramsParams withCategoryKey(String categoryKey) {
        this.categoryKey = categoryKey;
        return this;
    }

    public String getProgramKey() {
        return programKey;
    }

    public CashbackProgramsParams withProgramKey(String programKey) {
        this.programKey = programKey;
        return this;
    }

    public String getPercent() {
        return percent;
    }

    public CashbackProgramsParams withPercent(String percent) {
        this.percent = percent;
        return this;
    }

    public String getNameRu() {
        return nameRu;
    }

    public CashbackProgramsParams withNameRu(String nameRu) {
        this.nameRu = nameRu;
        return this;
    }

    public String getNameEn() {
        return nameEn;
    }

    public CashbackProgramsParams withNameEn(String nameEn) {
        this.nameEn = nameEn;
        return this;
    }

    public String getTooltipInfoRu() {
        return tooltipInfoRu;
    }

    public CashbackProgramsParams withTooltipInfoRu(String tooltipInfoRu) {
        this.tooltipInfoRu = tooltipInfoRu;
        return this;
    }

    public String getTooltipInfoEn() {
        return tooltipInfoEn;
    }

    public CashbackProgramsParams withTooltipInfoEn(String tooltipInfoEn) {
        this.tooltipInfoEn = tooltipInfoEn;
        return this;
    }

    public String getTooltipLinkTextRu() {
        return tooltipLinkTextRu;
    }

    public CashbackProgramsParams withTooltipLinkTextRu(String tooltipLinkTextRu) {
        this.tooltipLinkTextRu = tooltipLinkTextRu;
        return this;
    }

    public String getTooltipLinkTextEn() {
        return tooltipLinkTextEn;
    }

    public CashbackProgramsParams withTooltipLinkTextEn(String tooltipLinkTextEn) {
        this.tooltipLinkTextEn = tooltipLinkTextEn;
        return this;
    }

    public String getTooltipLink() {
        return tooltipLink;
    }

    public CashbackProgramsParams withTooltipLink(String tooltipLink) {
        this.tooltipLink = tooltipLink;
        return this;
    }

    public Boolean getIsEnabled() {
        return isEnabled;
    }

    public CashbackProgramsParams withIsEnabled(Boolean enabled) {
        isEnabled = enabled;
        return this;
    }

    public Boolean getIsPublic() {
        return isPublic;
    }

    public CashbackProgramsParams withIsPublic(Boolean aPublic) {
        isPublic = aPublic;
        return this;
    }

    public Boolean getIsTechnical() {
        return isTechnical;
    }

    public CashbackProgramsParams withIsTechnical(Boolean aTechnical) {
        isTechnical = aTechnical;
        return this;
    }

    public Boolean getIsNew() {
        return isNew;
    }

    public CashbackProgramsParams withIsNew(Boolean aNew) {
        isNew = aNew;
        return this;
    }
}
