package ru.yandex.direct.internaltools.tools.cashback.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsCashbackProgram {
    @JsonProperty("id")
    private Long id;

    @JsonProperty("Категория")
    private String categoryName;

    @JsonProperty("Процент")
    private BigDecimal percent;

    @JsonProperty("Название программы (ru)")
    private String nameRu;

    @JsonProperty("Название программы (en)")
    private String nameEn;

    @JsonProperty("Текст в всплывающем окне (ru)")
    private String tooltipInfoRu;

    @JsonProperty("Текст в всплывающем окне (en)")
    private String tooltipInfoEn;

    @JsonProperty("Текст ссылки в всплывающем окне (ru)")
    private String tooltipLinkTextRu;

    @JsonProperty("Текст ссылки в всплывающем окне (en)")
    private String tooltipLinkTextEn;

    @JsonProperty("Ссылка в всплывающем окне")
    private String tooltipLink;

    @JsonProperty("Публичная")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isPublic;

    @JsonProperty("Активна")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isEnabled;

    @JsonProperty("Техническая")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isTechnical;

    @JsonProperty("Новая")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isNew;

    public Long getId() {
        return id;
    }

    public InternalToolsCashbackProgram withId(Long id) {
        this.id = id;
        return this;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public InternalToolsCashbackProgram withCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    public BigDecimal getPercent() {
        return percent;
    }

    public InternalToolsCashbackProgram withPercent(BigDecimal percent) {
        this.percent = percent;
        return this;
    }

    public String getNameRu() {
        return nameRu;
    }

    public InternalToolsCashbackProgram withNameRu(String nameRu) {
        this.nameRu = nameRu;
        return this;
    }

    public String getNameEn() {
        return nameEn;
    }

    public InternalToolsCashbackProgram withNameEn(String nameEn) {
        this.nameEn = nameEn;
        return this;
    }

    public String getTooltipInfoRu() {
        return tooltipInfoRu;
    }

    public InternalToolsCashbackProgram withTooltipInfoRu(String tooltipInfoRu) {
        this.tooltipInfoRu = tooltipInfoRu;
        return this;
    }

    public String getTooltipInfoEn() {
        return tooltipInfoEn;
    }

    public InternalToolsCashbackProgram withTooltipInfoEn(String tooltipInfoEn) {
        this.tooltipInfoEn = tooltipInfoEn;
        return this;
    }

    public String getTooltipLinkTextRu() {
        return tooltipLinkTextRu;
    }

    public InternalToolsCashbackProgram withTooltipLinkTextRu(String tooltipLinkTextRu) {
        this.tooltipLinkTextRu = tooltipLinkTextRu;
        return this;
    }

    public String getTooltipLinkTextEn() {
        return tooltipLinkTextEn;
    }

    public InternalToolsCashbackProgram withTooltipLinkTextEn(String tooltipLinkTextEn) {
        this.tooltipLinkTextEn = tooltipLinkTextEn;
        return this;
    }

    public String getTooltipLink() {
        return tooltipLink;
    }

    public InternalToolsCashbackProgram withTooltipLink(String tooltipLink) {
        this.tooltipLink = tooltipLink;
        return this;
    }

    public Boolean getIsPublic() {
        return isPublic;
    }

    public InternalToolsCashbackProgram withIsPublic(Boolean aPublic) {
        isPublic = aPublic;
        return this;
    }

    public Boolean getIsEnabled() {
        return isEnabled;
    }

    public InternalToolsCashbackProgram withIsEnabled(Boolean enabled) {
        isEnabled = enabled;
        return this;
    }

    public Boolean getIsTechnical() {
        return isTechnical;
    }

    public InternalToolsCashbackProgram withIsTechnical(Boolean aTechnical) {
        isTechnical = aTechnical;
        return this;
    }

    public Boolean getIsNew() {
        return isNew;
    }

    public InternalToolsCashbackProgram withIsNew(Boolean aNew) {
        isNew = aNew;
        return this;
    }
}
