package ru.yandex.direct.internaltools.tools.cashback.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class InternalToolsCashbackProgramCategory {
    @JsonProperty("Id")
    private Long id;

    @JsonProperty("Id категории")
    private Long categoryId;

    @JsonProperty("Название категории (ru)")
    private String categoryName;

    @JsonProperty("Id программы")
    private Long programId;

    @JsonProperty("Название программы (ru)")
    private String programName;

    @JsonProperty("Порядок программы в карточке категории")
    private Long order;

    public Long getId() {
        return id;
    }

    public InternalToolsCashbackProgramCategory withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public InternalToolsCashbackProgramCategory withCategoryId(Long categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public InternalToolsCashbackProgramCategory withCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    public Long getProgramId() {
        return programId;
    }

    public InternalToolsCashbackProgramCategory withProgramId(Long programId) {
        this.programId = programId;
        return this;
    }

    public String getProgramName() {
        return programName;
    }

    public InternalToolsCashbackProgramCategory withProgramName(String programName) {
        this.programName = programName;
        return this;
    }

    public Long getOrder() {
        return order;
    }

    public InternalToolsCashbackProgramCategory withOrder(Long order) {
        this.order = order;
        return this;
    }
}
