package ru.yandex.direct.internaltools.tools.cashback.model;


import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.File;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.cashback.preprocessors.CashbackProgramSelectPreprocessor;

public class ManageClientsCashbackParams extends InternalToolParameter {

    public enum Action {
        ADD("Добавить в программу"),
        REMOVE("Удалить из программы");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Input(label = "Действие")
    @Select
    private Action action;

    @Input(label = "Программа", processors = CashbackProgramSelectPreprocessor.class)
    @Select(preprocessed = true)
    private String programKey;

    @Input(label = "Список ClientID через запятую", required = false)
    @Text
    private String clientIds;

    @File
    @Input(label = "Файл со списком ClientID", required = false, description = "ClientID должны быть перечислены через запятую")
    private byte[] file;

    public Action getAction() {
        return action;
    }

    public ManageClientsCashbackParams withAction(Action action) {
        this.action = action;
        return this;
    }

    public String getProgramKey() {
        return programKey;
    }

    public ManageClientsCashbackParams withProgramKey(String programKey) {
        this.programKey = programKey;
        return this;
    }

    public String getClientIds() {
        return clientIds;
    }

    public ManageClientsCashbackParams withClientIds(String clientIds) {
        this.clientIds = clientIds;
        return this;
    }

    public byte[] getFile() {
        return file;
    }

    public ManageClientsCashbackParams withFile(byte[] file) {
        this.file = file;
        return this;
    }
}
