package ru.yandex.direct.internaltools.tools.cashback.preprocessors;

import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.cashback.service.CashbackCategoriesService;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConverter.getCategoryKey;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class CashbackCategorySelectPreprocessor implements InternalToolInputPreProcessor<String> {
    private final CashbackCategoriesService cashbackCategoriesService;

    @Autowired
    public CashbackCategorySelectPreprocessor(CashbackCategoriesService cashbackCategoriesService) {
        this.cashbackCategoriesService = cashbackCategoriesService;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        var allowedValues = mapList(cashbackCategoriesService.getAllCategories(),
                category -> getCategoryKey(category.getId(), category.getNameRu()));
        Set<String> valid = new HashSet<>(allowedValues);
        valid.add(""); // Чтобы дефолтное значение проходило валидацию
        return inputBuilder
                .withDefaultValue(null)
                .withRequired(false)
                .withAllowedValues(allowedValues)
                .addValidator(inSet(valid));
    }
}
