package ru.yandex.direct.internaltools.tools.cashback.preprocessors;

import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.cashback.service.CashbackProgramsService;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.internaltools.tools.cashback.model.CashbackProgramKey;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class CashbackProgramSelectPreprocessor implements InternalToolInputPreProcessor<String> {

    @Autowired
    private CashbackProgramsService cashbackProgramsService;

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        var programs = cashbackProgramsService.getAllPrograms();
        var programKeys = mapList(programs, CashbackProgramKey::fromCashbackProgram);
        var allowedValues = mapList(programKeys, CashbackProgramKey::toDisplayString);
        Set<String> valid = new HashSet<>(allowedValues);
        valid.add(""); // Чтобы дефолтное значение проходило валидацию
        return inputBuilder
                .withDefaultValue(null)
                .withRequired(false)
                .withAllowedValues(allowedValues)
                .addValidator(inSet(valid));
    }
}
