package ru.yandex.direct.internaltools.tools.cashback.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.cashback.model.CashbackCategory;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppcdict.tables.CashbackCategories.CASHBACK_CATEGORIES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
public class CashbackCategoriesWriteRepository {
    private final JooqMapperWithSupplier<CashbackCategory> categoryMapper;
    private final DslContextProvider dslContextProvider;

    public CashbackCategoriesWriteRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.categoryMapper = JooqMapperWithSupplierBuilder.builder(CashbackCategory::new)
                .map(property(CashbackCategory.ID, CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID))
                .map(property(CashbackCategory.NAME_RU, CASHBACK_CATEGORIES.NAME_RU))
                .map(property(CashbackCategory.NAME_EN, CASHBACK_CATEGORIES.NAME_EN))
                .map(property(CashbackCategory.DESCRIPTION_RU, CASHBACK_CATEGORIES.DESCRIPTION_RU))
                .map(property(CashbackCategory.DESCRIPTION_EN, CASHBACK_CATEGORIES.DESCRIPTION_EN))
                .map(property(CashbackCategory.BUTTON_TEXT_RU, CASHBACK_CATEGORIES.BUTTON_TEXT_RU))
                .map(property(CashbackCategory.BUTTON_TEXT_EN, CASHBACK_CATEGORIES.BUTTON_TEXT_EN))
                .map(property(CashbackCategory.BUTTON_LINK, CASHBACK_CATEGORIES.BUTTON_LINK))
                .build();
    }

    public void update(Collection<AppliedChanges<CashbackCategory>> appliedChanges) {
        var updateBuilder = new JooqUpdateBuilder<>(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID, appliedChanges);
        updateBuilder.processProperty(CashbackCategory.NAME_RU, CASHBACK_CATEGORIES.NAME_RU);
        updateBuilder.processProperty(CashbackCategory.NAME_EN, CASHBACK_CATEGORIES.NAME_EN);
        updateBuilder.processProperty(CashbackCategory.DESCRIPTION_RU, CASHBACK_CATEGORIES.DESCRIPTION_RU);
        updateBuilder.processProperty(CashbackCategory.DESCRIPTION_EN, CASHBACK_CATEGORIES.DESCRIPTION_EN);
        updateBuilder.processProperty(CashbackCategory.BUTTON_TEXT_RU, CASHBACK_CATEGORIES.BUTTON_TEXT_RU);
        updateBuilder.processProperty(CashbackCategory.BUTTON_TEXT_EN, CASHBACK_CATEGORIES.BUTTON_TEXT_EN);
        updateBuilder.processProperty(CashbackCategory.BUTTON_LINK, CASHBACK_CATEGORIES.BUTTON_LINK);
        dslContextProvider.ppcdict()
                .update(CASHBACK_CATEGORIES)
                .set(updateBuilder.getValues())
                .where(CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID.in(updateBuilder.getChangedIds()))
                .execute();
    }

    public List<Long> add(List<CashbackCategory> categories) {
        return InsertHelper.addModelsAndReturnIds(dslContextProvider.ppcdict(), CASHBACK_CATEGORIES,
                categoryMapper, categories, CASHBACK_CATEGORIES.CASHBACK_CATEGORY_ID);
    }
}
