package ru.yandex.direct.internaltools.tools.cashback.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.cashback.model.CashbackProgramCategory;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppcdict.tables.CashbackProgramsCategories.CASHBACK_PROGRAMS_CATEGORIES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
public class CashbackProgramsCategoriesWriteRepository {
    private final JooqMapperWithSupplier<CashbackProgramCategory> programCategoryMapper;
    private final DslContextProvider dslContextProvider;

    @Autowired
    public CashbackProgramsCategoriesWriteRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.programCategoryMapper = JooqMapperWithSupplierBuilder.builder(CashbackProgramCategory::new)
                .map(property(CashbackProgramCategory.ID, CASHBACK_PROGRAMS_CATEGORIES.LINK_ID))
                .map(property(CashbackProgramCategory.CATEGORY_ID, CASHBACK_PROGRAMS_CATEGORIES.CASHBACK_CATEGORY_ID))
                .map(property(CashbackProgramCategory.PROGRAM_ID, CASHBACK_PROGRAMS_CATEGORIES.CASHBACK_PROGRAM_ID))
                .map(property(CashbackProgramCategory.ORDER, CASHBACK_PROGRAMS_CATEGORIES.ORDER))
                .build();
    }

    public void update(Collection<AppliedChanges<CashbackProgramCategory>> appliedChanges) {
        var updateBuilder = new JooqUpdateBuilder<>(CASHBACK_PROGRAMS_CATEGORIES.LINK_ID, appliedChanges);
        updateBuilder.processProperty(CashbackProgramCategory.ORDER, CASHBACK_PROGRAMS_CATEGORIES.ORDER);
        dslContextProvider.ppcdict()
                .update(CASHBACK_PROGRAMS_CATEGORIES)
                .set(updateBuilder.getValues())
                .where(CASHBACK_PROGRAMS_CATEGORIES.LINK_ID.in(updateBuilder.getChangedIds()))
                .execute();
    }

    public void add(List<CashbackProgramCategory> programCategories) {
        InsertHelper.saveModelObjectsToDbTable(dslContextProvider.ppcdict(), CASHBACK_PROGRAMS_CATEGORIES,
                programCategoryMapper, programCategories);
    }

    public void delete(CashbackProgramCategory programCategory) {
        dslContextProvider.ppcdict()
                .delete(CASHBACK_PROGRAMS_CATEGORIES)
                .where(CASHBACK_PROGRAMS_CATEGORIES.CASHBACK_PROGRAM_ID.eq(programCategory.getProgramId()))
                .and(CASHBACK_PROGRAMS_CATEGORIES.CASHBACK_CATEGORY_ID.eq(programCategory.getCategoryId()))
                .execute();
    }
}
