package ru.yandex.direct.internaltools.tools.cashback.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.cashback.model.CashbackProgram;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppcdict.tables.CashbackCategories.CASHBACK_CATEGORIES;
import static ru.yandex.direct.dbschema.ppcdict.tables.CashbackPrograms.CASHBACK_PROGRAMS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Repository
public class CashbackProgramsWriteRepository {
    private final JooqMapperWithSupplier<CashbackProgram> programMapper;
    private final DslContextProvider dslContextProvider;

    @Autowired
    public CashbackProgramsWriteRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.programMapper = JooqMapperWithSupplierBuilder.builder(CashbackProgram::new)
                .map(property(CashbackProgram.ID, CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID))
                .map(property(CashbackProgram.CATEGORY_ID, CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID))
                .map(property(CashbackProgram.PERCENT, CASHBACK_PROGRAMS.PERCENT))
                .map(property(CashbackProgram.NAME_RU, CASHBACK_PROGRAMS.NAME_RU))
                .map(property(CashbackProgram.NAME_EN, CASHBACK_PROGRAMS.NAME_EN))
                .map(property(CashbackProgram.TOOLTIP_INFO_RU, CASHBACK_PROGRAMS.TOOLTIP_INFO_RU))
                .map(property(CashbackProgram.TOOLTIP_INFO_EN, CASHBACK_PROGRAMS.TOOLTIP_INFO_EN))
                .map(property(CashbackProgram.TOOLTIP_LINK_TEXT_RU, CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_RU))
                .map(property(CashbackProgram.TOOLTIP_LINK_TEXT_EN, CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_EN))
                .map(property(CashbackProgram.TOOLTIP_LINK, CASHBACK_PROGRAMS.TOOLTIP_LINK))
                .map(booleanProperty(CashbackProgram.IS_PUBLIC, CASHBACK_PROGRAMS.IS_GENERAL))
                .map(booleanProperty(CashbackProgram.IS_ENABLED, CASHBACK_PROGRAMS.IS_ENABLED))
                .map(booleanProperty(CashbackProgram.IS_TECHNICAL, CASHBACK_PROGRAMS.IS_TECHNICAL))
                .map(booleanProperty(CashbackProgram.IS_NEW, CASHBACK_PROGRAMS.IS_NEW))
                .readProperty(CashbackProgram.CATEGORY_NAME_RU, fromField(CASHBACK_CATEGORIES.NAME_RU))
                .readProperty(CashbackProgram.CATEGORY_NAME_EN, fromField(CASHBACK_CATEGORIES.NAME_EN))
                .readProperty(CashbackProgram.CATEGORY_DESCRIPTION_RU, fromField(CASHBACK_CATEGORIES.DESCRIPTION_RU))
                .readProperty(CashbackProgram.CATEGORY_DESCRIPTION_EN, fromField(CASHBACK_CATEGORIES.DESCRIPTION_EN))
                .build();
    }

    public void update(Collection<AppliedChanges<CashbackProgram>> appliedChanges) {
        var updateBuilder = new JooqUpdateBuilder<>(CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID, appliedChanges);
        updateBuilder.processProperty(CashbackProgram.PERCENT, CASHBACK_PROGRAMS.PERCENT);
        updateBuilder.processProperty(CashbackProgram.NAME_RU, CASHBACK_PROGRAMS.NAME_RU);
        updateBuilder.processProperty(CashbackProgram.NAME_EN, CASHBACK_PROGRAMS.NAME_EN);
        updateBuilder.processProperty(CashbackProgram.CATEGORY_ID, CASHBACK_PROGRAMS.CASHBACK_CATEGORY_ID);
        updateBuilder.processProperty(CashbackProgram.TOOLTIP_INFO_RU, CASHBACK_PROGRAMS.TOOLTIP_INFO_RU);
        updateBuilder.processProperty(CashbackProgram.TOOLTIP_INFO_EN, CASHBACK_PROGRAMS.TOOLTIP_INFO_EN);
        updateBuilder.processProperty(CashbackProgram.TOOLTIP_LINK_TEXT_RU, CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_RU);
        updateBuilder.processProperty(CashbackProgram.TOOLTIP_LINK_TEXT_EN, CASHBACK_PROGRAMS.TOOLTIP_LINK_TEXT_EN);
        updateBuilder.processProperty(CashbackProgram.TOOLTIP_LINK, CASHBACK_PROGRAMS.TOOLTIP_LINK);
        updateBuilder.processProperty(CashbackProgram.IS_ENABLED, CASHBACK_PROGRAMS.IS_ENABLED, RepositoryUtils::booleanToLong);
        updateBuilder.processProperty(CashbackProgram.IS_PUBLIC, CASHBACK_PROGRAMS.IS_GENERAL, RepositoryUtils::booleanToLong);
        updateBuilder.processProperty(CashbackProgram.IS_TECHNICAL, CASHBACK_PROGRAMS.IS_TECHNICAL, RepositoryUtils::booleanToLong);
        updateBuilder.processProperty(CashbackProgram.IS_NEW, CASHBACK_PROGRAMS.IS_NEW, RepositoryUtils::booleanToLong);
        dslContextProvider.ppcdict()
                .update(CASHBACK_PROGRAMS)
                .set(updateBuilder.getValues())
                .where(CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID.in(updateBuilder.getChangedIds()))
                .execute();
    }

    public List<Long> add(List<CashbackProgram> programs) {
        return InsertHelper.addModelsAndReturnIds(dslContextProvider.ppcdict(), CASHBACK_PROGRAMS,
                programMapper, programs, CASHBACK_PROGRAMS.CASHBACK_PROGRAM_ID);
    }
}
