package ru.yandex.direct.internaltools.tools.cashback.service;

import ru.yandex.direct.env.Environment;
import ru.yandex.direct.mail.EmailAddress;
import ru.yandex.direct.mail.MailMessage;

import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.NOTIFICATIONS_EMAIL;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.NOTIFICATIONS_FROM_EMAIL;
import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.NOTIFICATIONS_TEST_EMAIL;

public class ActionNotificationMailMessage extends MailMessage {
    private static final String MAIL_PERSONAL = "direct-cashback-notifications";

    public ActionNotificationMailMessage(String subject, String messageBody) {
        super(getFromEmail(), getToEmail(), subject, messageBody);
    }

    private static EmailAddress getFromEmail() {
        return new EmailAddress(NOTIFICATIONS_FROM_EMAIL, MAIL_PERSONAL);
    }

    private static EmailAddress getToEmail() {
        var email = Environment.getCached().isProduction() ? NOTIFICATIONS_EMAIL : NOTIFICATIONS_TEST_EMAIL;
        return new EmailAddress(email, MAIL_PERSONAL);
    }
}
