package ru.yandex.direct.internaltools.tools.cashback.service;

import java.util.List;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.cashback.model.CashbackCategory;
import ru.yandex.direct.core.entity.cashback.repository.CashbackCategoriesRepository;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.internaltools.tools.cashback.repository.CashbackCategoriesWriteRepository;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;

@Service
public class CashbackCategoriesWriteService {

    private final CashbackCategoriesRepository readRepository;
    private final CashbackCategoriesWriteRepository writeRepository;
    private final CashbackNotificationsService notificationsService;

    @Autowired
    public CashbackCategoriesWriteService(
            CashbackCategoriesRepository readRepository,
            CashbackCategoriesWriteRepository writeRepository,
            CashbackNotificationsService notificationsService) {
        this.readRepository = readRepository;
        this.writeRepository = writeRepository;
        this.notificationsService = notificationsService;
    }

    @Nullable
    public CashbackCategory createCategory(User operator, CashbackCategory category) {
        var ids = writeRepository.add(List.of(category));
        var createdCategory = ids.isEmpty() ? null : readRepository.get(ids.get(0));
        if (createdCategory != null) {
            notificationsService.notifyCategoryCreated(createdCategory, operator);
        }
        return createdCategory;
    }

    public CashbackCategory updateCategory(User operator, CashbackCategory category) {
        var existingCategory = readRepository.get(category.getId());
        var appliedChanges = List.of(toAppliedChanges(category, existingCategory));
        writeRepository.update(appliedChanges);
        var updatedCategory = readRepository.get(category.getId());
        notificationsService.notifyCategoryUpdated(updatedCategory, operator);
        return updatedCategory;
    }

    private AppliedChanges<CashbackCategory> toAppliedChanges(CashbackCategory update, CashbackCategory existing) {
        return new ModelChanges<>(update.getId(), CashbackCategory.class)
                .processNotNull(update.getNameRu(), CashbackCategory.NAME_RU)
                .processNotNull(update.getNameEn(), CashbackCategory.NAME_EN)
                .processNotNull(update.getDescriptionRu(), CashbackCategory.DESCRIPTION_RU)
                .processNotNull(update.getDescriptionEn(), CashbackCategory.DESCRIPTION_EN)
                .processNotNull(update.getButtonTextRu(), CashbackCategory.BUTTON_TEXT_RU)
                .processNotNull(update.getButtonTextEn(), CashbackCategory.BUTTON_TEXT_EN)
                .processNotNull(update.getButtonLink(), CashbackCategory.BUTTON_LINK)
                .applyTo(existing);
    }
}
