package ru.yandex.direct.internaltools.tools.cashback.tool;

import java.math.BigDecimal;
import java.util.Set;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.env.Environment;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

public class InternalToolsCashbackConstants {
    public static final int CATEGORY_NAME_MAX_LENGTH = 48;
    public static final int CATEGORY_DESCRIPTION_MAX_LENGTH = 108;
    public static final int CATEGORY_BUTTON_TEXT_MAX_LENGTH = 48;
    public static final int CATEGORY_BUTTON_LINK_MAX_LENGTH = 2048;
    public static final int PROGRAM_NAME_MAX_LENGTH = 48;
    public static final int PROGRAM_TOOLTIP_INFO_MAX_LENGTH = 108;
    public static final int PROGRAM_TOOLTIP_LINK_TEXT_MAX_LENGTH = 48;
    public static final int PROGRAM_TOOLTIP_LINK_MAX_LENGTH = 2048;

    public static final String CATEGORY_FIELD_UPDATE_PROMPT =
            "Для сохранения текущего значения при обновлении оставьте поле пустым";
    public static final String CATEGORY_KEY_SEPARATOR = "-";

    public static final BigDecimal PERCENT_MIN_VALUE = BigDecimal.ZERO;
    public static final int PERCENT_MAX_VALUE_INT = 600;
    public static final BigDecimal PERCENT_MAX_VALUE = new BigDecimal(PERCENT_MAX_VALUE_INT);

    public static final String NOTIFICATIONS_FROM_EMAIL = "direct_noreply@yandex-team.ru";
    public static final String NOTIFICATIONS_EMAIL = "direct-loyalty-program-info@yandex-team.ru";
    public static final String NOTIFICATIONS_TEST_EMAIL = "direct-loyalty-program-info-test@yandex-team.ru";

    private static final Set<String> WRITE_PERMISSION_LOGINS = Set.of(
            "yndx-irpakhomov-super",
            "yndx-dmsuvorov-super");

    public static final Validator<User, Defect> WRITE_PERMISSION_VALIDATOR = input -> {
        ItemValidationBuilder<User, Defect> vb = ItemValidationBuilder.of(input);
        vb.item(input.getLogin(), "login")
                .check(inSet(WRITE_PERMISSION_LOGINS), When.isTrue(Environment.getCached().isProduction()));
        return vb.getResult();
    };

    private InternalToolsCashbackConstants() {
    }
}
