package ru.yandex.direct.internaltools.tools.cashback.tool;

import java.math.BigDecimal;
import java.math.RoundingMode;

import javax.annotation.Nullable;

import org.apache.commons.lang.StringUtils;

import ru.yandex.direct.core.entity.cashback.model.CashbackCategory;
import ru.yandex.direct.core.entity.cashback.model.CashbackProgram;
import ru.yandex.direct.core.entity.cashback.model.CashbackProgramCategoryExtended;
import ru.yandex.direct.internaltools.tools.cashback.model.CashbackCategoriesParams;
import ru.yandex.direct.internaltools.tools.cashback.model.CashbackProgramsParams;
import ru.yandex.direct.internaltools.tools.cashback.model.InternalToolsCashbackCategory;
import ru.yandex.direct.internaltools.tools.cashback.model.InternalToolsCashbackProgram;
import ru.yandex.direct.internaltools.tools.cashback.model.InternalToolsCashbackProgramCategory;

import static ru.yandex.direct.internaltools.tools.cashback.tool.InternalToolsCashbackConstants.CATEGORY_KEY_SEPARATOR;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class InternalToolsCashbackConverter {
    private static final BigDecimal PERCENT_MULTIPLIER = new BigDecimal(100);

    private InternalToolsCashbackConverter() {
    }

    public static InternalToolsCashbackCategory toInternalToolsCashbackCategory(CashbackCategory category) {
        return new InternalToolsCashbackCategory()
                .withId(category.getId())
                .withNameRu(category.getNameRu())
                .withNameEn(category.getNameEn())
                .withDescriptionRu(category.getDescriptionRu())
                .withDescriptionEn(category.getDescriptionEn())
                .withButtonTextRu(category.getButtonTextRu())
                .withButtonTextEn(category.getButtonTextEn())
                .withButtonLink(category.getButtonLink());
    }

    public static CashbackCategory toCashbackCategory(CashbackCategoriesParams params) {
        return new CashbackCategory()
                .withNameRu(params.getNameRu())
                .withNameEn(params.getNameEn())
                .withDescriptionRu(params.getDescriptionRu())
                .withDescriptionEn(params.getDescriptionEn())
                .withButtonTextRu(params.getButtonTextRu())
                .withButtonTextEn(params.getButtonTextEn())
                .withButtonLink(params.getButtonLink());
    }

    public static InternalToolsCashbackProgram toInternalToolsCashbackProgram(CashbackProgram program) {
        return new InternalToolsCashbackProgram()
                .withId(program.getId())
                .withCategoryName(program.getCategoryNameRu())
                .withPercent(toDisplayPercent(program.getPercent()))
                .withNameRu(program.getNameRu())
                .withNameEn(program.getNameEn())
                .withTooltipInfoRu(program.getTooltipInfoRu())
                .withTooltipInfoEn(program.getTooltipInfoEn())
                .withTooltipLinkTextRu(program.getTooltipLinkTextRu())
                .withTooltipLinkTextEn(program.getTooltipLinkTextEn())
                .withTooltipLink(program.getTooltipLink())
                .withIsPublic(program.getIsPublic())
                .withIsEnabled(program.getIsEnabled())
                .withIsTechnical(program.getIsTechnical())
                .withIsNew(program.getIsNew());
    }

    public static CashbackProgram toCashbackProgram(CashbackProgramsParams params) {
        return new CashbackProgram()
                .withPercent(fromDisplayPercent(params.getPercent()))
                .withNameRu(params.getNameRu())
                .withNameEn(params.getNameEn())
                .withTooltipInfoRu(params.getTooltipInfoRu())
                .withTooltipInfoEn(params.getTooltipInfoEn())
                .withTooltipLinkTextRu(params.getTooltipLinkTextRu())
                .withTooltipLinkTextEn(params.getTooltipLinkTextEn())
                .withTooltipLink(params.getTooltipLink())
                .withIsEnabled(params.getIsEnabled())
                .withIsPublic(params.getIsPublic())
                .withIsTechnical(params.getIsTechnical())
                .withIsNew(params.getIsNew());
    }

    public static InternalToolsCashbackProgramCategory toInternalToolsCashbackProgramCategory(
            CashbackProgramCategoryExtended programCategory) {
        return new InternalToolsCashbackProgramCategory()
                .withId(programCategory.getId())
                .withCategoryId(programCategory.getCategoryId())
                .withCategoryName(programCategory.getCategoryNameRu())
                .withProgramId(programCategory.getProgramId())
                .withProgramName(programCategory.getProgramNameRu())
                .withOrder(programCategory.getOrder());
    }

    public static BigDecimal toDisplayPercent(BigDecimal percent) {
        return percent.multiply(PERCENT_MULTIPLIER);
    }

    @Nullable
    public static BigDecimal fromDisplayPercent(@Nullable String displayPercent) {
        if (displayPercent == null) {
            return null;
        }
        return new BigDecimal(displayPercent)
                .setScale(4, RoundingMode.DOWN)
                .divide(PERCENT_MULTIPLIER, RoundingMode.DOWN);
    }

    public static String getCategoryKey(Long id, String name) {
        return id + " " + CATEGORY_KEY_SEPARATOR + " " + name;
    }

    public static Long getIdFromCategoryKey(String categoryKey) {
        return ifNotNull(categoryKey, idNameString -> {
            var idString = idNameString.split(CATEGORY_KEY_SEPARATOR)[0].trim();
            return StringUtils.isNumeric(idString)
                    ? Long.valueOf(idString)
                    : null;
        });
    }
}
