package ru.yandex.direct.internaltools.tools.clientcountrycurrency;


import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.internaltools.tools.clientcountrycurrency.container.ClientCountryAndCurrencies;

@Service
@ParametersAreNonnullByDefault
public class ClientCountryCurrencyService {
    private final ShardHelper shardHelper;
    private final ClientCountryCurrencyRepository clientCountryCurrencyRepository;

    @Autowired
    public ClientCountryCurrencyService(ShardHelper shardHelper,
                                        ClientCountryCurrencyRepository clientCountryCurrencyRepository) {
        this.shardHelper = shardHelper;
        this.clientCountryCurrencyRepository = clientCountryCurrencyRepository;
    }

    public List<ClientCountryAndCurrencies> getClientCountryAndCurrencies(Long clientId) {
        int shard = shardHelper.getShardByClientIdStrictly(ClientId.fromLong(clientId));
        return clientCountryCurrencyRepository.getClientCountryAndCurrencies(shard, clientId);
    }
}
