package ru.yandex.direct.internaltools.tools.clientcountrycurrency;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.clientcountrycurrency.container.ClientCountryAndCurrencies;
import ru.yandex.direct.internaltools.tools.clientcountrycurrency.model.ClientCountryCurrencyParameters;
import ru.yandex.direct.utils.PassportUtils;


@Tool(
        name = "Список страна-валюта по клиенту",
        label = "client_country_currency",
        description = "Просмотр страны и валюты по клиенту",
        consumes = ClientCountryCurrencyParameters.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.MULTICURRENCY)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.SUPERREADER, InternalToolAccessRole.SUPPORT})
@ParametersAreNonnullByDefault
public class ClientCountryCurrencyTool extends MassInternalTool<ClientCountryCurrencyParameters, ClientCountryAndCurrencies> {

    private final ShardHelper shardHelper;
    private final ClientCountryCurrencyService clientCountryCurrencyService;

    public ClientCountryCurrencyTool(ShardHelper shardHelper,
                                     ClientCountryCurrencyService clientCountryCurrencyService) {
        this.shardHelper = shardHelper;
        this.clientCountryCurrencyService = clientCountryCurrencyService;
    }

    @Override
    protected List<ClientCountryAndCurrencies> getMassData(ClientCountryCurrencyParameters parameter) {
        String login = PassportUtils.normalizeLogin(parameter.getLogin());
        Long clientId = shardHelper.getClientIdByLogin(login);
        return clientId == null ? Collections.emptyList() : clientCountryCurrencyService.getClientCountryAndCurrencies(clientId);
    }
}
