package ru.yandex.direct.internaltools.tools.clientcountrycurrency.container;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Инкапсулирует триплет 'страна-валюты-дата обновления' на клиента
 */
public class ClientCountryAndCurrencies {
    @JsonProperty("Страна")
    private final String country;
    @JsonProperty("Валюты")
    private final String currencies;
    @JsonProperty("Дата обновления")
    private final LocalDateTime lastUpdate;


    public ClientCountryAndCurrencies(String country, String currencies, LocalDateTime lastUpdate) {
        this.country = country;
        this.currencies = currencies;
        this.lastUpdate = lastUpdate;
    }
}
