package ru.yandex.direct.internaltools.tools.clientmotivationmail;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.motivationmail.MotivationMailNotificationType;
import ru.yandex.direct.core.entity.motivationmail.MotivationMailService;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.HideInProduction;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.clientmotivationmail.model.ClientMotivationMailParamerers;

import static ru.yandex.direct.internaltools.tools.clientmotivationmail.model.ClientMotivationMailParamerers.FOURTEEN_DAYS_AGO;
import static ru.yandex.direct.internaltools.tools.clientmotivationmail.model.ClientMotivationMailParamerers.SIX_DAYS_AGO;

@Tool(
        name = "Настройка отправки писем через рассылятор",
        label = "client_reminder_letters",
        description = "Для указанного клиента может менять последнюю отправленную нотификацию и время её отправки",
        consumes = ClientMotivationMailParamerers.class,
        type = InternalToolType.WRITER
)
@Category(InternalToolCategory.TESTING)
@Action(InternalToolAction.SET)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
@HideInProduction
public class ClientMotivationMailTool implements BaseInternalTool<ClientMotivationMailParamerers> {

    private final MotivationMailService motivationMailService;

    @Autowired
    public ClientMotivationMailTool(MotivationMailService motivationMailService) {
        this.motivationMailService = motivationMailService;
    }

    @Override
    public InternalToolResult process(ClientMotivationMailParamerers parameter) {
        Long clientid = parameter.getClientid();
        MotivationMailNotificationType lastSentNotification = parameter.getLastSentNotification();
        LocalDateTime notificationTime = parameter.getNotificationTime();
        String textSelect = parameter.getTextSelect();

        if (textSelect.equals(SIX_DAYS_AGO)) {
            notificationTime = LocalDateTime.now().minusDays(6L);
        }
        if (textSelect.equals(FOURTEEN_DAYS_AGO)) {
            notificationTime = LocalDateTime.now().minusDays(14L);
        }

        motivationMailService.updateNotificationInfo(clientid, lastSentNotification, notificationTime);
        return new InternalToolResult()
                .withMessage("Ок");
    }
}
