package ru.yandex.direct.internaltools.tools.clientmotivationmail.model;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.motivationmail.MotivationMailNotificationType;
import ru.yandex.direct.internaltools.core.annotations.input.DateTime;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class ClientMotivationMailParamerers extends InternalToolParameter {

    public static final String SPECIFIED_DAYS_AGO = "как указано в поле";
    public static final String SIX_DAYS_AGO = "6 дней назад";
    public static final String FOURTEEN_DAYS_AGO = "14 дней назад";

    @Input(label = "СlientID")
    @Number
    private Long clientid;

    @Input(label = "Отправленная нотификация", required = false)
    private MotivationMailNotificationType lastSentNotification;

    @Input(label = "Когда была отправлена нотификация")
    @Select(choices = {SPECIFIED_DAYS_AGO, SIX_DAYS_AGO, FOURTEEN_DAYS_AGO})
    private String textSelect;

    @Input(label = "Время отправки нотификации")
    @DateTime(now = true)
    private LocalDateTime notificationTime;

    public Long getClientid() {
        return clientid;
    }

    public MotivationMailNotificationType getLastSentNotification() {
        return lastSentNotification;
    }

    public String getTextSelect() {
        return textSelect;
    }

    public LocalDateTime getNotificationTime() {
        return notificationTime;
    }
}
