package ru.yandex.direct.internaltools.tools.clientndsschedule.container;

import java.time.format.DateTimeFormatter;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.client.model.ClientNds;
import ru.yandex.direct.currency.Percent;

public class ClientNdsScheduleInfo {
    @JsonProperty("С")
    private String dateFrom;

    @JsonProperty("По")
    private String dateTo;

    @JsonProperty("НДС, %")
    private Percent vat;

    public ClientNdsScheduleInfo(ClientNds clientNds) {
        this.dateFrom = clientNds.getDateFrom().format(DateTimeFormatter.ISO_DATE);
        this.dateTo = clientNds.getDateTo().format(DateTimeFormatter.ISO_DATE);
        this.vat = clientNds.getNds();
    }

    public ClientNdsScheduleInfo withDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public ClientNdsScheduleInfo withDateTo(String dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public ClientNdsScheduleInfo withVat(Percent vat) {
        this.vat = vat;
        return this;
    }
}
