package ru.yandex.direct.internaltools.tools.communication.model;

import java.time.LocalDateTime;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public abstract class BaseCommunicationEventVersionsParameters<T extends BaseCommunicationEventVersionsParameters<?>>
        extends InternalToolParameter {
    public abstract CommunicationEventVersionsAction getAction();

    public abstract String getEvent();

    public abstract Long getEventId();

    public abstract Long getIteration();

    public abstract LocalDateTime getStartEventTime();

    public abstract LocalDateTime getExpired();

    public abstract String getTitle();

    public abstract String getText();

    public abstract String getButtonText();

    public abstract String getButtonHref();

    public abstract String getImageHref();

    public abstract T withIteration(Long iteration);
}
