package ru.yandex.direct.internaltools.tools.communication.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.Select
import ru.yandex.direct.internaltools.core.annotations.input.Text
import ru.yandex.direct.internaltools.core.container.InternalToolParameter
import ru.yandex.direct.internaltools.tools.communication.model.providers.CommunicationEventConfigurableTypesSelectProvider

data class CommunicationConfigurationParameters(
    @Text
    @Input(label = "Тип события", processors = [CommunicationEventConfigurableTypesSelectProvider::class])
    @Select(preprocessed = true)
    val event: String,
    @Text
    @Input(label = "Итерация", required = false)
    val iteration: Long? = null,
    @Text
    @Input(label = "Действие")
    val action: CommunicationConfigurationAction
) : InternalToolParameter() {
    val eventId: Long
        get() = event.split(":").toTypedArray()[0].toLong()
}
