package ru.yandex.direct.internaltools.tools.communication.model;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.communication.model.providers.CommunicationEventTypesActualSelectProvider;

public class CommunicationEventTypesParameters extends InternalToolParameter {
    @Text
    @Input(label = "Идентификатор события", processors = CommunicationEventTypesActualSelectProvider.class,
            required = false)
    @Select(preprocessed = true)
    private String chosenEvent;

    @Input(label = "Название события (для добавления события)", required = false)
    private String eventName;

    @Input(label = "Логины ответственных без пробелов через запятую (для добавления события)", required =
            false)
    private String ownerLogins;

    @Text
    @Input(label = "Действие")
    private CommunicationEventTypesAction action;

    @Text
    @Input(label = "Показывать заархивированные")
    @CheckBox(checked = false)
    private Boolean showArchived;

    @Text
    @Input(label = "Показывать новые")
    @CheckBox(checked = true)
    private Boolean showNew;

    @Text
    @Input(label = "Показывать активные")
    @CheckBox(checked = true)
    private Boolean showActive;

    private Set<String> parsedOwnerLogins;

    public String getChosenEvent() {
        return chosenEvent;
    }

    public Long getChosenEventId() {
        return chosenEvent == null ? null : Long.parseLong(chosenEvent.split(":")[0]);
    }

    public CommunicationEventTypesParameters withChosenEvent(String chosenEvent) {
        this.chosenEvent = chosenEvent;
        return this;
    }

    public String getEventName() {
        return eventName;
    }

    public CommunicationEventTypesParameters withEventName(String name) {
        this.eventName = name;
        return this;
    }

    public String getOwnerLogins() {
        return ownerLogins;
    }

    public Set<String> getParsedOwnerLogins() {
        if (parsedOwnerLogins == null) {
            parsedOwnerLogins = ownerLogins == null
                    ? new HashSet<>()
                    : StreamEx.of(ownerLogins.split(","))
                    .map(String::trim)
                    .filter(l -> !StringUtils.isEmpty(l))
                    .collect(Collectors.toSet());
        }
        return parsedOwnerLogins;
    }

    public CommunicationEventTypesParameters withOwnerLogins(String ownerLogins) {
        this.ownerLogins = ownerLogins;
        return this;
    }

    public CommunicationEventTypesAction getAction() {
        return action;
    }

    public CommunicationEventTypesParameters withLaunchAction(CommunicationEventTypesAction launchAction) {
        this.action = launchAction;
        return this;
    }

    public Boolean getShowArchived() {
        return showArchived;
    }

    public CommunicationEventTypesParameters withShowArchived(Boolean showArchived) {
        this.showArchived = showArchived;
        return this;
    }

    public Boolean getShowNew() {
        return showNew;
    }

    public CommunicationEventTypesParameters withShowNew(Boolean showNew) {
        this.showNew = showNew;
        return this;
    }

    public Boolean getShowActive() {
        return showActive;
    }

    public CommunicationEventTypesParameters setShowActive(Boolean showActive) {
        this.showActive = showActive;
        return this;
    }
}
