package ru.yandex.direct.internaltools.tools.communication.model;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.communication.model.CommunicationEventStatus;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventType;

public class CommunicationEventTypesResponse {

    @JsonProperty("Id события")
    private Long eventId;

    @JsonProperty("Название события")
    private String name;

    @JsonProperty("Владельцы события")
    private String owners;

    @JsonProperty("Тип события")
    private CommunicationEventType type;

    @JsonProperty("Статус события")
    private CommunicationEventStatus status;

    @JsonProperty("Время архивации")
    private LocalDateTime archiveTime;

    @JsonProperty("Время активации итерации")
    private LocalDateTime activationTime;

    public Long getEventId() {
        return eventId;
    }

    public CommunicationEventTypesResponse withEventId(Long eventId) {
        this.eventId = eventId;
        return this;
    }

    public String getName() {
        return name;
    }

    public CommunicationEventTypesResponse withName(String name) {
        this.name = name;
        return this;
    }

    public String getOwners() {
        return owners;
    }

    public CommunicationEventTypesResponse withOwners(String owners) {
        this.owners = owners;
        return this;
    }

    public CommunicationEventType getType() {
        return type;
    }

    public CommunicationEventTypesResponse withType(CommunicationEventType type) {
        this.type = type;
        return this;
    }

    public CommunicationEventStatus getStatus() {
        return status;
    }

    public CommunicationEventTypesResponse withStatus(CommunicationEventStatus status) {
        this.status = status;
        return this;
    }

    public LocalDateTime getArchiveTime() {
        return archiveTime;
    }

    public CommunicationEventTypesResponse withArchiveTime(LocalDateTime archiveTime) {
        this.archiveTime = archiveTime;
        return this;
    }

    public LocalDateTime ActivationTime() {
        return activationTime;
    }

    public CommunicationEventTypesResponse withActivationTime(LocalDateTime activationTime) {
        this.activationTime = activationTime;
        return this;
    }
}
