package ru.yandex.direct.internaltools.tools.communication.model;

import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersionStatus;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.communication.model.providers.AllCommunicationEventTypesAllSelectProvider;

public class CommunicationEventVersionStatusParameters extends InternalToolParameter {

    @Text
    @Input(label = "Тип события", processors = {AllCommunicationEventTypesAllSelectProvider.class})
    @Select(preprocessed = true)
    private String event;

    @Input(label = "Итерация")
    @NumericId
    private Long iteration;

    @Text
    @Input(label = "Статус")
    private CommunicationEventVersionStatus status;

    public String getEvent() {
        return event;
    }

    public Long getEventId() {
        return event == null ? null : Long.parseLong(event.split(":")[0]);
    }

    public Long getIteration() {
        return iteration;
    }

    public CommunicationEventVersionStatus getStatus() {
        return status;
    }
}
