package ru.yandex.direct.internaltools.tools.communication.model;

import java.time.LocalDateTime;

import ru.yandex.direct.internaltools.core.annotations.input.DateTime;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.tools.communication.model.providers.CommunicationEventTypesActualSelectProvider;

public class CommunicationEventVersionsParameters
        extends BaseCommunicationEventVersionsParameters<CommunicationEventVersionsParameters> {

    @Text
    @Input(label = "Действие")
    private CommunicationEventVersionsAction action;

    @Text
    @Input(label = "Тип события", processors = {CommunicationEventTypesActualSelectProvider.class})
    @Select(preprocessed = true)
    private String event;

    @Input(label = "Итерация", required = false)
    @NumericId
    private Long iteration;

    @Input(label = "Время старта", required = false)
    @DateTime(now = true, dayShift = 1)
    private LocalDateTime startEventTime;

    @Input(label = "Время окончания", required = false)
    @DateTime(now = true, dayShift = 8)
    private LocalDateTime expired;

    @Text
    @Input(label = "Пользователи", required = false)
    private String users;

    @Text
    @Input(label = "Заголовок", required = false)
    private String title;

    @Text
    @Input(label = "Текст", required = false)
    private String text;

    @Text
    @Input(label = "Текст кнопки", required = false)
    private String buttonText;

    @Text
    @Input(label = "Ссылка", required = false)
    private String buttonHref;

    @Text
    @Input(label = "Изображение", required = false)
    private String imageHref;

    @Override
    public CommunicationEventVersionsAction getAction() {
        return action;
    }

    @Override
    public String getEvent() {
        return event;
    }

    @Override
    public Long getEventId() {
        return event == null ? null : Long.parseLong(event.split(":")[0]);
    }

    @Override
    public Long getIteration() {
        return iteration;
    }

    @Override
    public LocalDateTime getStartEventTime() {
        return startEventTime;
    }

    @Override
    public LocalDateTime getExpired() {
        return expired;
    }

    public String getUsers() {
        return users;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getText() {
        return text;
    }

    @Override
    public String getButtonText() {
        return buttonText;
    }

    @Override
    public String getButtonHref() {
        return buttonHref;
    }

    @Override
    public String getImageHref() {
        return imageHref;
    }


    public CommunicationEventVersionsParameters withEvent(String event) {
        this.event = event;
        return this;
    }

    @Override
    public CommunicationEventVersionsParameters withIteration(Long iteration) {
        this.iteration = iteration;
        return this;
    }

    public CommunicationEventVersionsParameters withStartEventTime(LocalDateTime startEventTime) {
        this.startEventTime = startEventTime;
        return this;
    }

    public CommunicationEventVersionsParameters withExpired(LocalDateTime expired) {
        this.expired = expired;
        return this;
    }

    public CommunicationEventVersionsParameters withUsers(String users) {
        this.users = users;
        return this;
    }

    public CommunicationEventVersionsParameters withTitle(String title) {
        this.title = title;
        return this;
    }

    public CommunicationEventVersionsParameters withText(String text) {
        this.text = text;
        return this;
    }

    public CommunicationEventVersionsParameters withButtonText(String buttonText) {
        this.buttonText = buttonText;
        return this;
    }

    public CommunicationEventVersionsParameters withButtonHref(String buttonHref) {
        this.buttonHref = buttonHref;
        return this;
    }

    public CommunicationEventVersionsParameters withImageHref(String imageHref) {
        this.imageHref = imageHref;
        return this;
    }
}
