package ru.yandex.direct.internaltools.tools.communication.model;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

public class CommunicationEventVersionsResponse {

    @JsonProperty("Id события")
    private Long eventId;

    @JsonProperty("Итерация")
    private Long iter;

    @JsonProperty("Статус")
    private String status;

    @JsonProperty("Время начала")
    private LocalDateTime startTime;

    @JsonProperty("Время окончания")
    private LocalDateTime expired;

    @JsonProperty("Пользователи")
    private String users;

    @JsonProperty("Данные")
    private String popupData;

    public CommunicationEventVersionsResponse(CommunicationEventVersion cev) {
        eventId = cev.getEventId();
        iter = cev.getIter();
        status = cev.getStatus().name();
        startTime = cev.getStartTime();
        expired = cev.getExpired();
        users = cev.getUsers();
        popupData = new StringBuilder()
                .append("Заголовок: ").append(cev.getTitle())
                .append("\nТекст: ").append(cev.getText())
                .append("\nКнопка: ").append(cev.getButtonText())
                .append("\nСсылка: ").append(cev.getButtonHref())
                .append("\nКартинка: ").append(cev.getImageHref())
                .toString();
    }
}
