package ru.yandex.direct.internaltools.tools.communication.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.input.Date;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.communication.model.providers.AllCommunicationEventTypesAllSelectProvider;

public class CommunicationStatisticParameters extends InternalToolParameter {

    @Text
    @Input(label = "Тип события", processors = {AllCommunicationEventTypesAllSelectProvider.class})
    @Select(preprocessed = true)
    private String event;

    @Text
    @Input(label = "Группировать")
    private GroupBy groupByPeriod;

    @Input(label = "Начало измерения", required = false)
    @Date
    private LocalDate startDate;

    @Input(label = "Конец измерения", required = false)
    @Date
    private LocalDate finishDate;

    public String getEvent() {
        return event;
    }

    public Long getEventId() {
        return event == null ? null : Long.parseLong(event.split(":")[0]);
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public LocalDate getFinishDate() {
        return finishDate;
    }

    public GroupBy getGroupByPeriod() {
        return groupByPeriod;
    }

    public enum GroupBy {
        @JsonProperty("-")
        NONE,
        @JsonProperty("по годам")
        YEAR,
        @JsonProperty("по кварталам")
        QUERTER,
        @JsonProperty("по месяцам")
        MONTH,
        @JsonProperty("по дням")
        DAY,
        @JsonProperty("по часам")
        HOUR,
        @JsonProperty("по 5-минуткам")
        MINUTE_5,
        @JsonProperty("по минутам")
        MINUTE,
    }
}
