package ru.yandex.direct.internaltools.tools.communication.model;

import java.time.LocalDateTime;

import ru.yandex.direct.internaltools.core.annotations.input.DateTime;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.tools.communication.model.providers.PopupClusterSelectProvider;
import ru.yandex.direct.internaltools.tools.communication.model.providers.PopupEventTypesActualSelectProvider;

public class PopupEventVersionsParameters
        extends BaseCommunicationEventVersionsParameters<PopupEventVersionsParameters> {
    @Text
    @Input(label = "Тип события", processors = {PopupEventTypesActualSelectProvider.class})
    @Select(preprocessed = true)
    private String event;

    @Text
    @Input(label = "Кластер", processors = {PopupClusterSelectProvider.class})
    @Select(preprocessed = true)
    private String cluster;

    @Text
    @Input(label = "Путь к таблице")
    private String tablePath;

    @Text
    @Input(label = "Действие")
    protected CommunicationEventVersionsAction action;

    @Input(label = "Итерация", required = false)
    @NumericId
    protected Long iteration;

    @Input(label = "Время старта", required = false)
    @DateTime(now = true, dayShift = 1)
    protected LocalDateTime startEventTime;

    @Input(label = "Время окончания", required = false)
    @DateTime(now = true, dayShift = 8)
    protected LocalDateTime expired;

    @Text
    @Input(label = "Заголовок", required = false)
    protected String title;

    @Text
    @Input(label = "Текст", required = false)
    protected String text;

    @Text
    @Input(label = "Текст кнопки", required = false)
    protected String buttonText;

    @Text
    @Input(label = "Ссылка", required = false)
    protected String buttonHref;

    @Text
    @Input(label = "Изображение", required = false)
    protected String imageHref;

    @Override
    public Long getEventId() {
        return event == null ? null : Long.parseLong(event.split(":")[0]);
    }

    @Override
    public CommunicationEventVersionsAction getAction() {
        return action;
    }

    @Override
    public String getEvent() {
        return event;
    }

    @Override
    public Long getIteration() {
        return iteration;
    }

    @Override
    public LocalDateTime getStartEventTime() {
        return startEventTime;
    }

    @Override
    public LocalDateTime getExpired() {
        return expired;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getText() {
        return text;
    }

    @Override
    public String getButtonText() {
        return buttonText;
    }

    @Override
    public String getButtonHref() {
        return buttonHref;
    }

    @Override
    public String getImageHref() {
        return imageHref;
    }

    public String getCluster() {
        return cluster;
    }

    public String getTablePath() {
        return tablePath;
    }

    public PopupEventVersionsParameters withEvent(String event) {
        this.event = event;
        return this;
    }

    @Override
    public PopupEventVersionsParameters withIteration(Long iteration) {
        this.iteration = iteration;
        return this;
    }

    public PopupEventVersionsParameters withStartEventTime(LocalDateTime startEventTime) {
        this.startEventTime = startEventTime;
        return this;
    }

    public PopupEventVersionsParameters withExpired(LocalDateTime expired) {
        this.expired = expired;
        return this;
    }

    public PopupEventVersionsParameters withTitle(String title) {
        this.title = title;
        return this;
    }

    public PopupEventVersionsParameters withText(String text) {
        this.text = text;
        return this;
    }

    public PopupEventVersionsParameters withButtonText(String buttonText) {
        this.buttonText = buttonText;
        return this;
    }

    public PopupEventVersionsParameters withButtonHref(String buttonHref) {
        this.buttonHref = buttonHref;
        return this;
    }

    public PopupEventVersionsParameters withImageHref(String imageHref) {
        this.imageHref = imageHref;
        return this;
    }

    public PopupEventVersionsParameters withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public PopupEventVersionsParameters withTablePath(String tablePath) {
        this.tablePath = tablePath;
        return this;
    }

}
