package ru.yandex.direct.internaltools.tools.communication.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.communication.model.providers.RecommendationTypesAllSelectProvider;

public class RecommendationVersionsParameters extends InternalToolParameter {

    @Text
    @Input(label = "Действие")
    private CommunicationEventVersionsAction action;

    @Text
    @Input(label = "Тип события", processors = {RecommendationTypesAllSelectProvider.class})
    @Select(preprocessed = true)
    private String event;

    @Input(label = "Итерация", required = false)
    @NumericId
    private Long iteration;

    @TextArea
    @Input(label = "Конфигурация", required = false)
    private String config;

    public CommunicationEventVersionsAction getAction() {
        return action;
    }

    public String getEvent() {
        return event;
    }

    public Long getEventId() {
        return event == null ? null : Long.parseLong(event.split(":")[0]);
    }

    public Long getIteration() {
        return iteration;
    }

    public String getConfig() {
        return config;
    }
}
