package ru.yandex.direct.internaltools.tools.communication.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;

import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.utils.JsonUtils;

public class RecommendationVersionsResponse {

    @JsonProperty("Id события")
    private Long eventId;

    @JsonProperty("Итерация")
    private Long iter;

    @JsonProperty("Статус")
    private String status;

    @JsonProperty("Конфигурация")
    private String config;

    public RecommendationVersionsResponse(CommunicationEventVersion cev) {
        eventId = cev.getEventId();
        iter = cev.getIter();
        status = cev.getStatus().name();
        try {
            config = JsonUtils.getObjectMapper().writeValueAsString(cev);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}
