package ru.yandex.direct.internaltools.tools.communication.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class SendPersonalCommunicationEventParameters extends InternalToolParameter {

    @Input(label = "Ссылка на изображение", required = false)
    private String imageHref;

    @Text
    @Input(label = "Заголовок сообщения", required = false)
    private String title;

    @Text
    @Input(label = "Текст сообщения", required = false)
    private String text;

    @Text
    @Input(label = "Текст кнопки", required = false)
    private String buttonText;

    @Text
    @Input(label = "Ссылка кнопки", required = false)
    private String buttonHref;

    public String getImageHref() {
        return imageHref;
    }

    public SendPersonalCommunicationEventParameters withImageLink(String imageLink) {
        this.imageHref = imageLink;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public SendPersonalCommunicationEventParameters withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getText() {
        return text;
    }

    public SendPersonalCommunicationEventParameters withText(String text) {
        this.text = text;
        return this;
    }

    public String getButtonText() {
        return buttonText;
    }

    public SendPersonalCommunicationEventParameters withButtonText(String buttonText) {
        this.buttonText = buttonText;
        return this;
    }

    public String getButtonHref() {
        return buttonHref;
    }

    public SendPersonalCommunicationEventParameters withHref(String href) {
        this.buttonHref = href;
        return this;
    }
}
