package ru.yandex.direct.internaltools.tools.communication.model.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableSet;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.communication.model.CommunicationEventStatus;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventType;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.internaltools.tools.communication.service.CommunicationEventTypesService;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

public abstract class AbstractCommunicationEventTypesSelectProvider implements InternalToolInputPreProcessor<String> {
    private static final String EMPTY_PLACEHOLDER = "";

    private final CommunicationEventTypesService communicationEventTypesService;
    private final List<CommunicationEventType> availableTypes;
    private final List<CommunicationEventStatus> availableTypeStatuses;

    protected AbstractCommunicationEventTypesSelectProvider(CommunicationEventTypesService communicationEventTypesService) {
        this.communicationEventTypesService = communicationEventTypesService;
        availableTypes = getAvailableTypes();
        availableTypeStatuses = getAvailableTypeStatuses();
    }

    abstract protected List<CommunicationEventType> getAvailableTypes();

    abstract protected List<CommunicationEventStatus> getAvailableTypeStatuses();

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        var events = communicationEventTypesService
                .getSortedEventsByTypesAndStatuses(availableTypes, availableTypeStatuses);
        List<String> eventIdsAndNames = StreamEx.of(events)
                .map(event -> event.getEventId() + ": " + event.getName())
                .collect(Collectors.toList());

        List<String> displayedValues = new ArrayList<>();
        displayedValues.add(EMPTY_PLACEHOLDER);
        displayedValues.addAll(eventIdsAndNames);

        return inputBuilder
                .withAllowedValues(displayedValues)
                .addValidator(inSet(ImmutableSet.copyOf(eventIdsAndNames)))
                .withDefaultValue(null);
    }
}
