package ru.yandex.direct.internaltools.tools.communication.model.providers;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.communication.model.CommunicationEventStatus;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventType;
import ru.yandex.direct.internaltools.tools.communication.service.CommunicationEventTypesService;

@Component
public class CommunicationEventConfigurableTypesSelectProvider extends AbstractCommunicationEventTypesSelectProvider {
    public CommunicationEventConfigurableTypesSelectProvider(
            CommunicationEventTypesService communicationEventTypesService
    ) {
        super(communicationEventTypesService);
    }

    @Override
    protected List<CommunicationEventType> getAvailableTypes() {
        return List.of(CommunicationEventType.RECOMMENDATION, CommunicationEventType.POPUP);
    }

    @Override
    protected List<CommunicationEventStatus> getAvailableTypeStatuses() {
        return List.of(CommunicationEventStatus.values());
    }
}
