package ru.yandex.direct.internaltools.tools.communication.model.providers;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.communication.model.CommunicationEventStatus;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventType;
import ru.yandex.direct.internaltools.tools.communication.service.CommunicationEventTypesService;

import static ru.yandex.direct.core.entity.communication.model.CommunicationEventStatus.ACTIVE;
import static ru.yandex.direct.core.entity.communication.model.CommunicationEventStatus.NEW_;

@Component
public class CommunicationEventTypesActualSelectProvider extends AbstractCommunicationEventTypesSelectProvider {

    public CommunicationEventTypesActualSelectProvider(CommunicationEventTypesService communicationEventTypesService) {
        super(communicationEventTypesService);
    }

    @Override
    protected List<CommunicationEventType> getAvailableTypes() {
        return List.of(CommunicationEventType.SINGLE_LAUNCH, CommunicationEventType.RECOMMENDATION);
    }

    @Override
    protected List<CommunicationEventStatus> getAvailableTypeStatuses() {
        return List.of(NEW_, ACTIVE);
    }
}
