package ru.yandex.direct.internaltools.tools.communication.model.providers;

import java.util.stream.Collectors;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;

@Component
public class PopupClusterSelectProvider implements InternalToolInputPreProcessor<String> {

    private final YtProvider ytProvider;

    @Autowired
    public PopupClusterSelectProvider(
            YtProvider ytProvider
    ) {
        this.ytProvider = ytProvider;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        var availableClusters = StreamEx.of(YtCluster.values())
                .filter(it -> it != YtCluster.YT_LOCAL)
                .map(YtCluster::getName)
                .collect(Collectors.toList());
        return inputBuilder
                .withAllowedValues(availableClusters)
                .withDefaultValue(YtCluster.HAHN.getName());
    }
}
