package ru.yandex.direct.internaltools.tools.contentcategories;

import java.util.List;

import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.contentcategories.model.ContentCategoriesBlockedDomainsRecord;
import ru.yandex.direct.internaltools.tools.contentcategories.model.ContentCategoriesBlockedDomainsUpdateParams;
import ru.yandex.direct.internaltools.tools.contentcategories.repository.ContentCategoriesBlockedDomainsYtRepository;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.internaltools.tools.contentcategories.model.ContentCategoriesBlockedDomainsUpdateParams.DOMAINS_LABEL;
import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.parseCommaSeparatedString;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Tool(
        name = "Редактирование списка заблокированных доменов для категорий и жанров",
        label = "content_categories_blocked_domains",
        description = "Позволяет редактировать список заблокированных доменов, " +
                "который применяется на этапе сбора урлов для разметки страниц категориями контента и brandsafety",
        consumes = ContentCategoriesBlockedDomainsUpdateParams.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.OTHER)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.SUPERREADER, InternalToolAccessRole.DEVELOPER})
public class ContentCategoriesBlockedDomainsTool extends
        MassInternalTool<ContentCategoriesBlockedDomainsUpdateParams, ContentCategoriesBlockedDomainsRecord> {

    private final ContentCategoriesBlockedDomainsYtRepository contentCategoriesBlockedDomainsYtRepository;

    public ContentCategoriesBlockedDomainsTool(
            ContentCategoriesBlockedDomainsYtRepository contentCategoriesBlockedDomainsYtRepository
    ) {
        this.contentCategoriesBlockedDomainsYtRepository = contentCategoriesBlockedDomainsYtRepository;
    }

    @Override
    protected List<ContentCategoriesBlockedDomainsRecord> getMassData(ContentCategoriesBlockedDomainsUpdateParams parameters) {
        var domains = parseCommaSeparatedString(parameters.getDomains());
        if (domains.isEmpty()) {
            return contentCategoriesBlockedDomainsYtRepository.getAll();
        }

        switch (parameters.getChangeAction()) {
            case ADD_OR_UPDATE_PATTERN:
                contentCategoriesBlockedDomainsYtRepository.insert(domains);
                break;

            case DELETE_PATTERN:
                contentCategoriesBlockedDomainsYtRepository.delete(domains);
                break;
        }

        return contentCategoriesBlockedDomainsYtRepository.getAll();
    }

    @Override
    public ValidationResult<ContentCategoriesBlockedDomainsUpdateParams, Defect> validate(
            ContentCategoriesBlockedDomainsUpdateParams parameters
    ) {
        ItemValidationBuilder<ContentCategoriesBlockedDomainsUpdateParams, Defect> vb =
                ItemValidationBuilder.of(parameters);
        vb.item(parameters.getDomains(), DOMAINS_LABEL).check(notBlank());
        return vb.getResult();
    }

    @Override
    protected List<ContentCategoriesBlockedDomainsRecord> getMassData() {
        return contentCategoriesBlockedDomainsYtRepository.getAll();
    }
}
