package ru.yandex.direct.internaltools.tools.contentcategories.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class ContentCategoriesBlockedDomainsUpdateParams extends InternalToolParameter {

    public static final String DOMAINS_LABEL = "Список доменов для блокировки (будет заблокирован сам домен и все поддомены)";

    @Select
    @Input(label = "Действие")
    private ChangeAction changeAction;

    @TextArea
    @Input(label = DOMAINS_LABEL)
    private String domains;

    public enum ChangeAction {
        ADD_OR_UPDATE_PATTERN("Добавить домены"),
        DELETE_PATTERN("Удалить домены");

        private final String description;

        ChangeAction(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    public ChangeAction getChangeAction() {
        return changeAction;
    }

    public void setChangeAction(ChangeAction changeAction) {
        this.changeAction = changeAction;
    }

    public String getDomains() {
        return domains;
    }

    public void setDomains(String domains) {
        this.domains = domains;
    }
}
