package ru.yandex.direct.internaltools.tools.contentcategories.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class ContentCategoriesWhitelistRecord {
    @JsonProperty("Паттерн")
    private String urlPattern;

    @JsonProperty("Категории для добавления")
    private String plusCategories;

    @JsonProperty("Категории для удаления")
    private String minusCategories;

    public String getUrlPattern() {
        return urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public ContentCategoriesWhitelistRecord withUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
        return this;
    }

    @Nullable
    public String getPlusCategories() {
        return plusCategories;
    }

    public void setPlusCategories(@Nullable String plusCategories) {
        this.plusCategories = plusCategories;
    }

    public ContentCategoriesWhitelistRecord withPlusCategories(@Nullable String plusCategories) {
        this.plusCategories = plusCategories;
        return this;
    }

    @Nullable
    public String getMinusCategories() {
        return minusCategories;
    }

    public void setMinusCategories(@Nullable String minusCategories) {
        this.minusCategories = minusCategories;
    }

    public ContentCategoriesWhitelistRecord withMinusCategories(@Nullable String minusCategories) {
        this.minusCategories = minusCategories;
        return this;
    }
}
