package ru.yandex.direct.internaltools.tools.contentcategories.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class ContentCategoriesWhitelistUpdateParams extends InternalToolParameter {

    public static final String URL_PATTERN_LABEL = "Паттерн (схема и параметры не учитываются, только host и path)";
    public static final String PLUS_CATEGORIES_LABEL = "Категории для добавления";
    public static final String MINUS_CATEGORIES_LABEL = "Категории для удаления";

    @Select
    @Input(label = "Действие")
    private ChangeAction changeAction;

    @Input(label = URL_PATTERN_LABEL)
    private String urlPattern;

    @Input(label = "Категории для добавления (bb_keyword_value через запятую)", required = false)
    private String plusCategories;

    @Input(label = "Категории для удаления (bb_keyword_value через запятую)", required = false)
    private String minusCategories;

    public enum ChangeAction {
        ADD_OR_UPDATE_PATTERN("Добавить или обновить паттерн"),
        DELETE_PATTERN("Удалить паттерн");

        private final String description;

        ChangeAction(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    public ChangeAction getChangeAction() {
        return changeAction;
    }

    public void setChangeAction(ChangeAction changeAction) {
        this.changeAction = changeAction;
    }

    public String getUrlPattern() {
        return urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getPlusCategories() {
        return plusCategories;
    }

    public void setPlusCategories(String plusCategories) {
        this.plusCategories = plusCategories;
    }

    public String getMinusCategories() {
        return minusCategories;
    }

    public void setMinusCategories(String minusCategories) {
        this.minusCategories = minusCategories;
    }
}
