package ru.yandex.direct.internaltools.tools.conversionsourcetype.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.conversionsourcetype.model.ConversionSourceTypeCode;

public class ConversionSourceTypeInfo {
    @JsonProperty("ID типа источника")
    private Long id;
    @JsonProperty("Название")
    private String name;
    @JsonProperty("Название на английском языке")
    private String nameEn;
    @JsonProperty("Описание")
    private String description;
    @JsonProperty("Описание на английском языке")
    private String descriptionEn;
    @JsonProperty("Ссылка на иконку")
    private String iconUrl;
    @JsonProperty("Ссылка на активацию или инструкцию по активации передачи конверсии")
    private String activationUrl;
    @JsonProperty("Флаг неопубликованных типов источников конверсий")
    private Boolean isDraft;
    @JsonProperty("Позиция типа источников конверсий для учета порядка")
    private Long position;
    @JsonProperty("enum типов источников конверсий")
    private ConversionSourceTypeCode code;
    @JsonProperty("Флаг разрешения на редактирование/удаление типа источников конверсий пользователем с внутренней ролью")
    private Boolean isEditable;

    public Long getId() {
        return id;
    }

    public ConversionSourceTypeInfo withId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public ConversionSourceTypeInfo withName(String name) {
        this.name = name;
        return this;
    }

    public String getNameEn() {
        return nameEn;
    }

    public ConversionSourceTypeInfo withNameEn(String nameEn) {
        this.nameEn = nameEn;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public ConversionSourceTypeInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescriptionEn() {
        return descriptionEn;
    }

    public ConversionSourceTypeInfo withDescriptionEn(String descriptionEn) {
        this.descriptionEn = descriptionEn;
        return this;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public ConversionSourceTypeInfo withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public String getActivationUrl() {
        return activationUrl;
    }

    public ConversionSourceTypeInfo withActivationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
        return this;
    }

    public Boolean getIsDraft() {
        return isDraft;
    }

    public ConversionSourceTypeInfo withIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    public Long getPosition() {
        return position;
    }

    public ConversionSourceTypeInfo withPosition(Long position) {
        this.position = position;
        return this;
    }

    public ConversionSourceTypeCode getCode() {
        return code;
    }

    public ConversionSourceTypeInfo withCode(ConversionSourceTypeCode code) {
        this.code = code;
        return this;
    }

    public Boolean getIsEditable() {
        return isEditable;
    }

    public ConversionSourceTypeInfo withIsEditable(Boolean isEditable) {
        this.isEditable = isEditable;
        return this;
    }
}
