package ru.yandex.direct.internaltools.tools.conversionsourcetype.model;

import ru.yandex.direct.core.entity.conversionsourcetype.model.ConversionSourceTypeCode;
import ru.yandex.direct.internaltools.core.annotations.input.File;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class ConversionSourceTypeInput extends InternalToolParameter {
    public static final String ACTION_LABEL = "Действие";
    public static final String ID_LABEL = "ID типа источников конверсии";
    public static final String NAME_LABEL = "Назавние типа источников конверсии";
    public static final String NAME_EN_LABEL = "Назавние типа источников конверсии на английском языке";
    public static final String DESCRIPTION_LABEL = "Описание типа источников конверсии";
    public static final String DESCRIPTION_EN_LABEL = "Описание типа источников конверсии на английском языке";
    public static final String ICON_LABEL = "Иконка";
    public static final String UNSET_ICON_LABEL = "Флаг для сброса иконки";
    public static final String ACTIVATION_URL_LABEL = "Ссылка на активацию или инструкцию по активации передачи " +
            "конверсии";
    public static final String UNSET_ACTIVATION_URL_LABEL = "Флаг для сброса ссылки на активацию или инструкцию по " +
            "активации передачи конверсии";
    public static final String IS_DRAFT_LABEL = "Флаг неопубликованных типов источников конверсий";
    public static final String POSITION_LABEL = "Позиция типа источников конверсий для учета порядка";
    public static final String CODE_LABEL = "enum типов источников конверсий";
    public static final String IS_EDITABLE_LABEL = "Флаг разрешения на редактирование/удаление типа источников " +
            "конверсий пользователем с внутренней ролью";

    @Input(label = ACTION_LABEL)
    private ConversionSourceTypeAction action;

    @Input(label = ID_LABEL, required = false,
            description = "Поле обязательно при изменении/удалении шаблона. " +
                    "Не учитывается при создании шаблона")
    private Long id;

    @Input(label = NAME_LABEL, required = false,
            description = "Поле обязательно при создании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Максимальная длина - 50 символов.")
    private String name;

    @Input(label = NAME_EN_LABEL, required = false,
            description = "Поле не обязательно при создании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Максимальная длина - 50 символов.")
    private String nameEn;

    @Input(label = DESCRIPTION_LABEL, required = false,
            description = "Поле обязательно при создании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Максимальная длина - 100 символов.")
    private String description;

    @Input(label = DESCRIPTION_EN_LABEL, required = false,
            description = "Поле не обязательно при создании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Максимальная длина - 100 символов.")
    private String descriptionEn;

    @File
    @Input(label = ICON_LABEL, required = false,
            description = "Поле НЕ является обязательным при создании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. ")
    private byte[] icon;

    @Input(label = UNSET_ICON_LABEL, required = false,
            description = "Поле обязательно при редактировании шаблона. " +
                    "Не учитывается при создании/удалении. " +
                    "При установлении значения true, значение поля iconUrl для редактируемой записи будет установлено" +
                    " в null")
    private Boolean unsetIconUrl;

    @Input(label = ACTIVATION_URL_LABEL, required = false,
            description = "Поле НЕ является обязательным при создании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Указывается только для конверсий типа OTHER, поле следует оставлять пустым для конверсий " +
                    "всех остальных типов")
    private String activationUrl;


    @Input(label = UNSET_ACTIVATION_URL_LABEL, required = false,
            description = "Поле обязательно при редактировании шаблона. " +
                    "Не учитывается при создании/удалении. " +
                    "При установлении значения true, значение поля activationUrl для редактируемой записи будет " +
                    "установлено в null")
    private Boolean unsetActivationUrl;

    @Input(label = IS_DRAFT_LABEL, required = false,
            description = "Поле обязательно при создании/редактировании шаблона. " +
                    "Не учитывается при удалении. " +
                    "При установленном значении true, тип будет доступен только для пользователей с внутренними " +
                    "ролями. " +
                    "При изменении значения с true на false, соответствующий тип будет виден всем пользователям.")
    private Boolean isDraft;

    @Input(label = POSITION_LABEL, required = false,
            description = "Поле обязательно при создании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Пустое значение при изменении шаблона оставит оригинальное значение. " +
                    "Данное поле устанавливает порядок следования типов в интерфейсе пользователя.")
    private Long position;

    @Input(label = CODE_LABEL, required = false,
            description = "Поле обязательно при изменении/удалении шаблона. " +
                    "Не учитывается при удалении. " +
                    "Не учитывается при создании шаблона. " +
                    "Для добавленных пользователем с внутренней ролью типах следует указывать OTHER.")
    private ConversionSourceTypeCode code;

    @Input(label = IS_EDITABLE_LABEL, required = false,
            description = "Поле обязательно при создании/редактировании шаблона. " +
                    "Не учитывается при удалении. " +
                    "Показывает какие из типов являются дефолтными и не редактируются/удаляются пользователем с " +
                    "внутренней ролью.")
    private Boolean isEditable;

    public ConversionSourceTypeAction getAction() {
        return action;
    }

    public ConversionSourceTypeInput withAction(ConversionSourceTypeAction action) {
        this.action = action;
        return this;
    }

    public Long getId() {
        return id;
    }

    public ConversionSourceTypeInput withId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public ConversionSourceTypeInput withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public ConversionSourceTypeInput withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getNameEn() {
        return nameEn;
    }

    public ConversionSourceTypeInput withNameEn(String nameEn) {
        this.nameEn = nameEn;
        return this;
    }

    public String getDescriptionEn() {
        return descriptionEn;
    }

    public ConversionSourceTypeInput withDescriptionEn(String descriptionEn) {
        this.descriptionEn = descriptionEn;
        return this;
    }

    public byte[] getIcon() {
        return icon;
    }

    public ConversionSourceTypeInput withIcon(byte[] icon) {
        this.icon = icon;
        return this;
    }

    public Boolean getUnsetIconUrl() {
        return unsetIconUrl;
    }

    public ConversionSourceTypeInput withUnsetIconUrl(boolean unsetIconUrl) {
        this.unsetIconUrl = unsetIconUrl;
        return this;
    }

    public String getActivationUrl() {
        return activationUrl;
    }

    public ConversionSourceTypeInput withActivationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
        return this;
    }

    public Boolean getUnsetActivationUrl() {
        return unsetActivationUrl;
    }

    public ConversionSourceTypeInput withUnsetActivationUrl(boolean unsetActivationUrl) {
        this.unsetActivationUrl = unsetActivationUrl;
        return this;
    }

    public Boolean getIsDraft() {
        return isDraft;
    }

    public ConversionSourceTypeInput withIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    public Long getPosition() {
        return position;
    }

    public ConversionSourceTypeInput withPosition(Long position) {
        this.position = position;
        return this;
    }

    public ConversionSourceTypeCode getCode() {
        return code;
    }

    public ConversionSourceTypeInput withCode(ConversionSourceTypeCode code) {
        this.code = code;
        return this;
    }

    public Boolean getIsEditable() {
        return isEditable;
    }

    public ConversionSourceTypeInput withIsEditable(Boolean isEditable) {
        this.isEditable = isEditable;
        return this;
    }

    @Override
    public String toString() {
        return "ConversionSourceType{" +
                "action=" + action +
                ", id=" + id +
                ", name=" + name +
                ", description=" + description +
                ", activationUrl=" + activationUrl +
                ", isDraft=" + isDraft +
                ", position=" + position +
                ", code=" + code +
                ", isEditable=" + isEditable +
                ", nameEn=" + nameEn +
                ", descriptionEn=" + descriptionEn +
                '}';
    }
}
