package ru.yandex.direct.internaltools.tools.conversionsourcetype.tool;

import ru.yandex.direct.core.entity.conversionsourcetype.model.ConversionSourceType;
import ru.yandex.direct.internaltools.tools.conversionsourcetype.model.ConversionSourceTypeInfo;
import ru.yandex.direct.internaltools.tools.conversionsourcetype.model.ConversionSourceTypeInput;

public class ConversionSourceTypeConverter {

    public static ConversionSourceTypeInfo fromConversionSourceType(ConversionSourceType conversionSourceType) {
        return new ConversionSourceTypeInfo()
                .withId(conversionSourceType.getId())
                .withName(conversionSourceType.getName())
                .withDescription(conversionSourceType.getDescription())
                .withIconUrl(conversionSourceType.getIconUrl())
                .withActivationUrl(conversionSourceType.getActivationUrl())
                .withIsDraft(conversionSourceType.getIsDraft())
                .withPosition(conversionSourceType.getPosition())
                .withCode(conversionSourceType.getCode())
                .withIsEditable(conversionSourceType.getIsEditable())
                .withNameEn(conversionSourceType.getNameEn())
                .withDescriptionEn(conversionSourceType.getDescriptionEn());
    }

    public static ConversionSourceType toConversionSourceType(ConversionSourceTypeInput conversionSourceTypeInput,
                                                              String iconUrl) {
        return toConversionSourceType(conversionSourceTypeInput).withIconUrl(iconUrl);
    }

    public static ConversionSourceType toConversionSourceType(ConversionSourceTypeInput conversionSourceTypeInput) {
        return new ConversionSourceType()
                .withId(conversionSourceTypeInput.getId())
                .withName(conversionSourceTypeInput.getName())
                .withDescription(conversionSourceTypeInput.getDescription())
                .withActivationUrl(conversionSourceTypeInput.getActivationUrl())
                .withIsDraft(conversionSourceTypeInput.getIsDraft())
                .withPosition(conversionSourceTypeInput.getPosition())
                .withCode(conversionSourceTypeInput.getCode())
                .withIsEditable(conversionSourceTypeInput.getIsEditable())
                .withNameEn(conversionSourceTypeInput.getNameEn())
                .withDescriptionEn(conversionSourceTypeInput.getDescriptionEn());
    }
}
