package ru.yandex.direct.internaltools.tools.deal.container;


import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Контейнер для хранения информации о владельце сделки
 */
@ParametersAreNonnullByDefault
public class SearchDealsInfo {

    @JsonProperty("Id сделки")
    private Long dealId;

    @JsonProperty("Логин агентства")
    private String login;

    @JsonProperty("ClientID")
    private Long clientId;

    public Long getDealId() {
        return dealId;
    }

    public SearchDealsInfo withDealId(Long dealId) {
        this.dealId = dealId;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public SearchDealsInfo withLogin(String login) {
        this.login = login;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public SearchDealsInfo withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }
}
