package ru.yandex.direct.internaltools.tools.deal.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class SearchDealsParameters extends InternalToolParameter {

    @TextArea
    @Input(label = "Номера сделок", description = "номера сделок должны быть отделены друг от друга запятой или любым whitespace символом")
    private String dealIds;

    public String getDealIds() {
        return dealIds;
    }

    public SearchDealsParameters withDealIds(String dealIds) {
        this.dealIds = dealIds;
        return this;
    }
}
