package ru.yandex.direct.internaltools.tools.ecom

import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup
import ru.yandex.direct.internaltools.core.annotations.tool.Action
import ru.yandex.direct.internaltools.core.annotations.tool.Category
import ru.yandex.direct.internaltools.core.annotations.tool.Tool
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole
import ru.yandex.direct.internaltools.core.enums.InternalToolAction
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory
import ru.yandex.direct.internaltools.core.enums.InternalToolType
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool
import ru.yandex.direct.internaltools.tools.ecom.model.DisableFeedInMbiJobLastTimePropertyData
import ru.yandex.direct.internaltools.tools.ecom.model.DisableFeedInMbiJobLastTimePropertyInfo
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Tool(
    name = "Выставить время последнего запуска джобы DisableFeedsInMBIJob",
    label = "disable_feeds_in_mbi_last_time_update_tool",
    description = "Управление пошардовой пропертей последнего запуска джобы DisableFeedsInMBIJob " +
        "— disable_feeds_in_mbi_last_time",
    consumes = DisableFeedInMbiJobLastTimePropertyData::class,
    type = InternalToolType.WRITER
)
@Category(InternalToolCategory.ECOM)
@Action(InternalToolAction.EXECUTE)
@AccessGroup(InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPER)
@ParametersAreNonnullByDefault
class DisableFeedInMbiJobLastTimePropertyTool(
    private val ppcPropertiesSupport: PpcPropertiesSupport,
    private val shardHelper: ShardHelper
) : MassInternalTool<DisableFeedInMbiJobLastTimePropertyData, DisableFeedInMbiJobLastTimePropertyInfo>() {
    override fun getMassData(parameter: DisableFeedInMbiJobLastTimePropertyData):
        List<DisableFeedInMbiJobLastTimePropertyInfo> {
        shardHelper.dbShards().forEach {
            getPropertyByShard(it).set(parameter.newValue)
        }
        return massData
    }

    override fun getMassData(): List<DisableFeedInMbiJobLastTimePropertyInfo> {
        return shardHelper.dbShards().map { shard ->
            DisableFeedInMbiJobLastTimePropertyInfo(
                PpcPropertyNames.disableFeedsInMBILastTime(shard).name,
                getPropertyByShard(shard).getOrDefault(LocalDateTime.MIN)
            )
        }
    }

    private fun getPropertyByShard(shard: Int) =
        ppcPropertiesSupport.get(PpcPropertyNames.disableFeedsInMBILastTime(shard))
}
